//
//  BlueToothPort.h
//  POSSDK
//
//  Created by duyuzhen on 13-6-26.
//  Copyright (c) 2013 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PortIO.h"
#import <UIKit/UIKit.h>

enum {
    MYPERIPHERAL_CONNECT_STATUS_IDLE = 0,
    MYPERIPHERAL_CONNECT_STATUS_CONNECTING,
    MYPERIPHERAL_CONNECT_STATUS_CONNECTED,
};


@interface BlueToothPeripheral : NSObject
{
	CBPeripheral   *peripheral;
	NSString       *advName;
	SInt32		   connectStaus;
}

@property (retain) CBPeripheral *peripheral;
@property(copy) NSString *advName;
@property (nonatomic, readwrite) SInt32 connectStaus;
@end

@interface BlueToothPort : PortIO

@property (nonatomic, retain) NSMutableArray*   connectedPeripheralList;

- (id)init;
@end

@interface BluetoothBLEUUID : NSObject
- (instancetype)initWithUUID:(NSString*)DEVICE_INFO_SERVICE
       MANUFACTURE_NAME_CHAR:(NSString*)MANUFACTURE_NAME_CHAR
           MODEL_NUMBER_CHAR:(NSString*)ODEL_NUMBER_CHAR
          SERIAL_NUMBER_CHAR:(NSString*)SERIAL_NUMBER_CHAR
      HARDWARE_REVISION_CHAR:(NSString*)HARDWARE_REVISION_CHAR
      FIRMWARE_REVISION_CHAR:(NSString*)FIRMWARE_REVISION_CHAR
      SOFTWARE_REVISION_CHAR:(NSString*)SOFTWARE_REVISION_CHAR
              SYSTEM_ID_CHAR:(NSString*)SYSTEM_ID_CHAR
       IEEE_11073_20601_CHAR:(NSString*)IEEE_11073_20601_CHAR
    ISSC_PROPRIETARY_SERVICE:(NSString*)ISSC_PROPRIETARY_SERVICE
   CONNECTION_PARAMETER_CHAR:(NSString*)CONNECTION_PARAMETER_CHAR
              AIR_PATCH_CHAR:(NSString*)AIR_PATCH_CHAR
               ISSC_TRANS_TX:(NSString*)ISSC_TRANS_TX
               ISSC_TRANS_RX:(NSString*)ISSC_TRANS_RX;


@property (retain, nonatomic, readonly) NSString* UUIDSTR_DEVICE_INFO_SERVICE;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_MANUFACTURE_NAME_CHAR;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_MODEL_NUMBER_CHAR;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_SERIAL_NUMBER_CHAR;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_HARDWARE_REVISION_CHAR;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_FIRMWARE_REVISION_CHAR;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_SOFTWARE_REVISION_CHAR;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_SYSTEM_ID_CHAR;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_IEEE_11073_20601_CHAR;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_ISSC_PROPRIETARY_SERVICE;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_CONNECTION_PARAMETER_CHAR;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_AIR_PATCH_CHAR;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_ISSC_TRANS_TX;
@property (retain, nonatomic, readonly) NSString* UUIDSTR_ISSC_TRANS_RX;
@end


